import { MemberProvider } from '@/integrations';
import { createBrowserRouter, RouterProvider, Navigate, Outlet } from 'react-router-dom';
import { ScrollToTop } from '@/lib/scroll-to-top';
import ErrorPage from '@/integrations/errorHandlers/ErrorPage';
import { MemberProtectedRoute } from '@/components/ui/member-protected-route';
import { AdminProtectedRoute } from '@/components/ui/admin-protected-route';
import HomePage from '@/components/pages/HomePage';
import AnimePage from '@/components/pages/AnimePage';
import MangaPage from '@/components/pages/MangaPage';
import AnimeDetailPage from '@/components/pages/AnimeDetailPage';
import MangaDetailPage from '@/components/pages/MangaDetailPage';
import NewsPage from '@/components/pages/NewsPage';
import NewsDetailPage from '@/components/pages/NewsDetailPage';
import ProfilePage from '@/components/pages/ProfilePage';
import AdminPage from '@/components/pages/AdminPage';
import FriendsPage from '@/components/pages/FriendsPage';
import MessagesPage from '@/components/pages/MessagesPage';

// Layout component that includes ScrollToTop
function Layout() {
  return (
    <>
      <ScrollToTop />
      <Outlet />
    </>
  );
}

const router = createBrowserRouter([
  {
    path: "/",
    element: <Layout />,
    errorElement: <ErrorPage />,
    children: [
      {
        index: true,
        element: <HomePage />,
      },
      {
        path: "anime",
        element: <AnimePage />,
      },
      {
        path: "anime/:id",
        element: <AnimeDetailPage />,
      },
      {
        path: "manga",
        element: <MangaPage />,
      },
      {
        path: "manga/:id",
        element: <MangaDetailPage />,
      },
      {
        path: "news",
        element: <NewsPage />,
      },
      {
        path: "news/:id",
        element: <NewsDetailPage />,
      },

      {
        path: "profile",
        element: (
          <MemberProtectedRoute messageToSignIn="Profilinizi görüntülemek için giriş yapın">
            <ProfilePage />
          </MemberProtectedRoute>
        ),
      },
      {
        path: "friends",
        element: (
          <MemberProtectedRoute messageToSignIn="Arkadaşlarınızı görüntülemek için giriş yapın">
            <FriendsPage />
          </MemberProtectedRoute>
        ),
      },
      {
        path: "messages/:userId",
        element: (
          <MemberProtectedRoute messageToSignIn="Mesajlaşmak için giriş yapın">
            <MessagesPage />
          </MemberProtectedRoute>
        ),
      },
      {
        path: "admin",
        element: (
          <AdminProtectedRoute allowedEmail="berkcanguler3@gmail.com">
            <AdminPage />
          </AdminProtectedRoute>
        ),
      },
      {
        path: "*",
        element: <Navigate to="/" replace />,
      },
    ],
  },
], {
  basename: import.meta.env.BASE_NAME,
});

export default function AppRouter() {
  return (
    <MemberProvider>
      <RouterProvider router={router} />
    </MemberProvider>
  );
}
