import { useMember } from '@/integrations';

export function useAdminAccess(allowedEmail: string = 'berkcanguler3@gmail.com') {
  const { member, isAuthenticated, isLoading } = useMember();
  
  const isAdmin = isAuthenticated && member?.loginEmail === allowedEmail;
  
  return {
    isAdmin,
    isAuthenticated,
    isLoading,
    userEmail: member?.loginEmail,
    allowedEmail
  };
}